package ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer;

import java.util.Map;

import ru.yandex.direct.core.entity.moderation.service.sending.ModerationSendingService;

public class BannersSendingContext implements ModerationSendingService.SendingContext {
    private final Map<String, String> parameterizedUrls;

    public BannersSendingContext(Map<String, String> parameterizedUrls, Map<Long, Long> bidToBusinessUnit) {
        this.parameterizedUrls = parameterizedUrls;
        this.bidToBusinessUnit = bidToBusinessUnit;
    }

    public Map<String, String> getParameterizedUrls() {
        return parameterizedUrls;
    }

    public String getParameterizedUrl(String originalUrl) {
        return parameterizedUrls.get(originalUrl);
    }

    private final Map<Long, Long> bidToBusinessUnit;

    public Map<Long, Long> getBidToBusinessUnit() {
        return bidToBusinessUnit;
    }
}
