package ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.implementations.HrefParameterizationRequestImpl;

public interface HrefParameterizingService {
    List<String> parameterize(int shard, List<HrefParameterizationRequest> requests);

    default <T> Map<String, String> getOriginalUrlToProcessed(
            int shard,
            List<T> objects,
            ReplacingParamsProvider<T> replacingParamsProvider,
            ObjectHrefProvider<T> hrefProvider
    ) {
        List<HrefParameterizationRequest> originalUrls = new ArrayList<>();
        for (T objectInfo : objects) {
            ReplacingParams replacingParams = replacingParamsProvider.fromObject(objectInfo);
            List<String> objectHrefs = hrefProvider.extractHrefs(objectInfo);
            objectHrefs.forEach(href -> originalUrls.add(
                    HrefParameterizationRequestImpl.builder()
                            .withHref(href)
                            .withReplacingParams(replacingParams)
                            .build()
            ));
        }
        List<String> processed = parameterize(shard, originalUrls);

        Map<String, String> processedUrls = new HashMap<>();
        EntryStream.zip(originalUrls, processed)
                .forKeyValue((orig, proc) -> processedUrls.put(orig.getHref(), proc));
        return processedUrls;
    }
}
