package ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer;

import java.util.List;
import java.util.Map;

public interface KeywordsInfoService {
    Map<Long, KeywordInfo> loadKeywordInfo(List<Long> pids, int shard);

    class KeywordInfo {
        private final String keyword;
        private final String param1;
        private final String param2;
        private final String phraseId;
        private final String retargetingId;

        public KeywordInfo(String keyword, String param1, String param2, String phraseId, String retargetingId) {
            this.keyword = keyword;
            this.param1 = param1;
            this.param2 = param2;
            this.phraseId = phraseId;
            this.retargetingId = retargetingId;
        }

        public String getKeyword() {
            return keyword;
        }

        public String getParam1() {
            return param1;
        }

        public String getParam2() {
            return param2;
        }

        public String getPhraseId() {
            return phraseId;
        }

        public String getRetargetingId() {
            return retargetingId;
        }
    }
}
