package ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.implementations.replacers.CampaignTypeReplacer;
import ru.yandex.direct.hrefs.parameterizer.HrefParameter;

/**
 * Все замены перенесены из перлового транспорта, куда они были добавлены в рамках тикета
 * https://st.yandex-team.ru/DIRECT-71679
 */

public class ParamReplacerFactory {

    public ParamReplacer get(HrefParameter parameter, Supplier<List<String>> domainsSupplier) {
        switch (parameter) {
            case AD_ID:
                return (params, context) -> params.getBid() == null ? "" : params.getBid().toString();
            case AD_GROUP_ID:
            case GBID:
                return (params, context) -> params.getPid() == null ? "" : params.getPid().toString();
            case CREATIVE_ID:
                return (params, context) -> params.getCreativeId() == null ? "0" : params.getCreativeId().toString();
            case CAMPAIGN_ID:
                return (p, context) -> p.getCid() == null ? "" : p.getCid().toString();
            case ADD_PHRASES:
                return (p, context) -> "no";
            case ADD_PHRASES_TEXT:
            case POSITION_TYPE:
                return (p, context) -> "none";
            case ADTARGET_ID:
            case LOGID:
            case TRACKID:
            case MATCH_TYPE:
            case MATCHED_KEYWORD:
            case OFFER_ID:
            case IDFA_LC_MD5_HEX:
            case IDFA_LC_SH1_HEX:
            case IOS_IFA:
            case INTEREST_ID:
            case GOOGLE_AID_LC_SH1:
            case GOOGLE_AID:
            case COEF_GOAL_CONTEXT_ID:
            case CAMPAIGN_NAME_LAT:
            case CAMPAIGN_CURRENCY:
            case CAMPAIGN_CURRENCY_CODE:
            case CAMPAIGN_COST_TYPE:
            case CAMPAIGN_COST:
            case ANDROID_ID_LC_SH1:
            case ANDROID_ID:
            case ADTARGET_NAME:
            case REGION_ID:
            case CAMPAIGN_NAME:
            case REGION_NAME:
            case OAID:
            case OAID_LC:
            case OAID_LC_SH1_HEX:
            case OAID_LC_MD5_HEX:
            case CLIENTIP:
            case USER_AGENT:
            case DEVICE_LANG:
            case YCLID:
                return (p, context) -> "";
            case CAMPAIGN_TYPE:
                return new CampaignTypeReplacer();
            case DEVICE_TYPE:
                return (p, context) -> "desktop";
            case KEYWORD:
                return (p, context) -> extractKeywordReplaceParam(context, p,
                        KeywordsInfoService.KeywordInfo::getKeyword);
            case PARAM1:
                return (p, context) -> extractKeywordReplaceParam(context, p,
                        KeywordsInfoService.KeywordInfo::getParam1);
            case PARAM2:
                return (p, context) -> extractKeywordReplaceParam(context, p,
                        KeywordsInfoService.KeywordInfo::getParam2);
            case PHRASE_ID:
                return (p, context) -> extractKeywordReplaceParam(context, p,
                        KeywordsInfoService.KeywordInfo::getPhraseId);
            case RETARGETING_ID:
                return (p, context) -> extractKeywordReplaceParam(context, p,
                        KeywordsInfoService.KeywordInfo::getRetargetingId);
            case POSITION:
                return (p, context) -> "0";
            case SOURCE:
                return (p, context) -> {
                    // Подставляем случайный домен из набора
                    // (чтобы спамеры не могли легко определять нашего робота по этому параметру)
                    List<String> domains = domainsSupplier.get();
                    return domains.isEmpty() ? "pogoda.yandex.ru" : domains.get(new Random().nextInt(domains.size()));
                };
            case SOURCE_TYPE:
                return (p, context) -> "context";
            default:
                throw new IllegalArgumentException("Unknown parameter " + parameter);
        }
    }

    private String extractKeywordReplaceParam(
            ReplacingContext context,
            ReplacingParams params,
            Function<KeywordsInfoService.KeywordInfo, String> paramExtractor
    ) {
        if (params.getPid() == null || context.getKeywords().get(params.getPid()) == null) {
            return null;
        }
        return paramExtractor.apply(context.getKeywords().get(params.getPid()));
    }
}
