package ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.implementations;

import java.util.Objects;

import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizationRequest;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.ReplacingParams;

public class HrefParameterizationRequestImpl implements HrefParameterizationRequest {
    private final String href;
    private final ReplacingParams replacingParams;

    private HrefParameterizationRequestImpl(String href, ReplacingParams replacingParams) {
        this.href = href;
        this.replacingParams = replacingParams;
    }

    @Override
    public String getHref() {
        return href;
    }

    @Override
    public ReplacingParams getParams() {
        return replacingParams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrefParameterizationRequestImpl that = (HrefParameterizationRequestImpl) o;

        return Objects.equals(href, that.href) &&
                Objects.equals(replacingParams, that.replacingParams);
    }

    @Override
    public int hashCode() {
        return Objects.hash(href, replacingParams);
    }

    public static HrefParameterizationRequestImplBuilder builder() {
        return new HrefParameterizationRequestImplBuilder();
    }

    public static final class HrefParameterizationRequestImplBuilder {
        private String href;
        private ReplacingParams replacingParams;

        private HrefParameterizationRequestImplBuilder() {
        }

        public HrefParameterizationRequestImplBuilder withHref(String href) {
            this.href = href;
            return this;
        }

        public HrefParameterizationRequestImplBuilder withReplacingParams(ReplacingParams replacingParams) {
            this.replacingParams = replacingParams;
            return this;
        }

        public HrefParameterizationRequestImpl build() {
            return new HrefParameterizationRequestImpl(href, replacingParams);
        }
    }
}
