package ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.implementations;

import java.util.Objects;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.ReplacingParams;

public class ReplacingParamsImpl implements ReplacingParams {
    private final Long bid;
    private final Long pid;
    private final Long cid;
    private final Long creativeId;
    private final CampaignType campaignType;

    private ReplacingParamsImpl(Long bid, Long pid, Long cid, Long creativeId, CampaignType campaignType) {
        this.bid = bid;
        this.pid = pid;
        this.cid = cid;
        this.creativeId = creativeId;
        this.campaignType = campaignType;
    }

    @Override
    public Long getBid() {
        return bid;
    }

    @Override
    public Long getPid() {
        return pid;
    }

    @Override
    public Long getCid() {
        return cid;
    }

    @Override
    public Long getCreativeId() {
        return creativeId;
    }

    @Override
    public CampaignType getCampaignType() {
        return campaignType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReplacingParamsImpl that = (ReplacingParamsImpl) o;
        return Objects.equals(bid, that.bid) &&
                Objects.equals(pid, that.pid) &&
                Objects.equals(cid, that.cid) &&
                Objects.equals(creativeId, that.creativeId) &&
                Objects.equals(campaignType, that.campaignType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bid, pid, cid, creativeId, campaignType);
    }

    public static ReplacingParamsImplBuilder builder() {
        return new ReplacingParamsImplBuilder();
    }

    public static final class ReplacingParamsImplBuilder {
        private Long bid;
        private Long pid;
        private Long cid;
        private Long creativeId;
        private CampaignType campaignType;

        private ReplacingParamsImplBuilder() {
        }

        public ReplacingParamsImplBuilder withBid(Long bid) {
            this.bid = bid;
            return this;
        }

        public ReplacingParamsImplBuilder withPid(Long pid) {
            this.pid = pid;
            return this;
        }

        public ReplacingParamsImplBuilder withCid(Long cid) {
            this.cid = cid;
            return this;
        }

        public ReplacingParamsImplBuilder withCreativeId(Long creativeId) {
            this.creativeId = creativeId;
            return this;
        }

        public ReplacingParamsImplBuilder withCampaignType(CampaignType campaignType) {
            this.campaignType = campaignType;
            return this;
        }

        public ReplacingParamsImpl build() {
            return new ReplacingParamsImpl(bid, pid, cid, creativeId, campaignType);
        }
    }
}
