package ru.yandex.direct.core.entity.moderation.service.sending.internalad

import one.util.streamex.StreamEx
import org.slf4j.LoggerFactory
import ru.yandex.direct.core.entity.banner.model.BannerWithInternalAdModerationInfo
import ru.yandex.direct.core.entity.image.model.BannerImageFormat
import ru.yandex.direct.core.entity.image.service.ImageUtils
import ru.yandex.direct.core.entity.internalads.Constants
import ru.yandex.direct.core.entity.moderation.model.AspectRatio
import ru.yandex.direct.core.entity.moderation.model.InternalBannerRequestData
import ru.yandex.direct.model.ModelProperty

object InternalBannerModerationHelper {

    private val logger = LoggerFactory.getLogger(InternalBannerModerationHelper::class.java)

    fun createInternalBannerRequestData(moderationInfo: BannerWithInternalAdModerationInfo,
                                        needAddDataForImages: Boolean,
                                        imageFormatByHash: Map<String, BannerImageFormat> = emptyMap(),
                                        moderationCountries: String = ""): InternalBannerRequestData {
        val internalModerationInfo = moderationInfo.moderationInfo
        val data = InternalBannerRequestData()
                .withObjectName(moderationInfo.description)
                .withGeo(moderationCountries)
                .withTicketUrl(internalModerationInfo.ticketUrl)
                .withAdditionalInformation(internalModerationInfo.customComment)
                .withIsSecretAd(internalModerationInfo.isSecretAd)
                .withTemplateId(moderationInfo.templateId)

        val resourceIdToProperty = Constants.MODERATED_TEMPLATES_RESOURCES_MAPPER[moderationInfo.templateId]!!
        StreamEx.of(moderationInfo.templateVariables)
                .mapToEntry { resourceIdToProperty[it.templateResourceId] }
                .nonNullValues()
                .mapKeys { it.internalValue }
                .nonNullKeys()
                .forKeyValue { value, targetProperty ->
                    setTemplateVariableValue(data, targetProperty!!, value, needAddDataForImages, imageFormatByHash)
                }

        return data
    }

    private fun setTemplateVariableValue(requestData: InternalBannerRequestData,
                                         targetProperty: ModelProperty<InternalBannerRequestData, String>,
                                         variableValue: String,
                                         needAddDataForImage: Boolean,
                                         imageFormatByHash: Map<String, BannerImageFormat>) {
        var valueToSet = variableValue

        // для картиночных переменных вместо хеша проставляем урл до картинки
        if (Constants.isImageProperty(targetProperty) && needAddDataForImage) {
            val bannerImageFormat = imageFormatByHash[variableValue]

            if (bannerImageFormat != null) {
                valueToSet = ImageUtils.generateSecureOrigImageUrl(bannerImageFormat)

                val imageAspectsProperty = Constants.IMAGE_PROPERTY_TO_ASPECTS[targetProperty]!!
                val imageSize = bannerImageFormat.size
                imageAspectsProperty.set(requestData, AspectRatio(imageSize.width.toLong(), imageSize.height.toLong()))
            } else {
                logger.error("not found bannerImageFormat for image with hash: {}", variableValue)
            }
        }

        targetProperty.set(requestData, valueToSet)
    }

}
