package ru.yandex.direct.core.entity.moderation.service.sending.internalad;

import java.util.Collections;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.BannersSendingContext;

@ParametersAreNonnullByDefault
//надо наследоваться от BannersSendingContext, чтобы в InternalBannerSender можно было наследоваться от BaseBannerSender
public class InternalBannersSendingContext extends BannersSendingContext {

    private final Map<String, BannerImageFormat> imageFormatByHash;

    public InternalBannersSendingContext(Map<String, BannerImageFormat> imageFormatByHash) {
        super(Collections.emptyMap(), Collections.emptyMap());
        this.imageFormatByHash = imageFormatByHash;
    }

    public Map<String, BannerImageFormat> getImageFormatByHash() {
        return imageFormatByHash;
    }

}
