package ru.yandex.direct.core.entity.moderationdiag

import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.databind.JsonNode
import ru.yandex.direct.utils.JsonUtils

private val titleRegex = "<h1(.*?)>(.*?)</h1>".toRegex(RegexOption.IGNORE_CASE)

private fun findTitle(content: String): String {
    val matchResult = titleRegex.find(content) ?: return ""

    return matchResult.groups[0]?.value ?: ""
}

data class DocCenterTooltipModelSelector(
    @JsonProperty(".title")
    val title: String
)

data class DocCenterTooltipModel(
    val content: String,
    val selector: DocCenterTooltipModelSelector
)

class DocCenterTooltipParsedData(val json: JsonNode) {
    fun title(): String {
        val titleFromSelector = json.get("selector")?.get(".title")

        if (titleFromSelector != null && titleFromSelector.asText().isNotEmpty()) {
            return titleFromSelector.asText()
        }

        return findTitle(json.get("content").asText())
    }

    fun content(): String {
        return json.get("content").asText();
    }

    fun json(): String {
        return JsonUtils.toJson(DocCenterTooltipModel(content(), DocCenterTooltipModelSelector(title())));
    }
}
