package ru.yandex.direct.core.entity.moderationdiag

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiag
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagData
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService

fun convert(diag: ModerationDiag): ModerationDiagData =
    ModerationDiagData(
        if (ModerationDiagService.needShowDetailsUrl(diag)) 1 else 0,
        diag.id.toString(),
        booleanToString(diag.strongReason),
        booleanToString(diag.unbanIsProhibited),
        diag.diagText,
        diag.token,
        diag.shortText,
        booleanToString(diag.allowFirstAid)
    )

fun convertList(diags: List<ModerationDiag>): List<ModerationDiagData> = diags.map { convert(it) }

private fun booleanToString(b: Boolean?): String {
    return if (b == true) {
        "Yes"
    } else {
        return if (b == false) "No" else ""
    }
}

