package ru.yandex.direct.core.entity.moderationdiag.model;

/**
 * По подобию https://a.yandex-team.ru/arc/trunk/arcadia/yabs/rmp/backend/src/uac/campaign/fabric.py?rev=r8093001#L759
 */
public class DiagReasonTitleAndDescription {
    private DiagReasonTitleAndDescription(String title, String description) {
        this.title = title;
        this.description = description;
    }

    private String title;
    private String description;

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    public static DiagReasonTitleAndDescriptionBuilder builder() {
        return new DiagReasonTitleAndDescriptionBuilder();
    }

    public static class DiagReasonTitleAndDescriptionBuilder {
        private String title;
        private String description;

        public DiagReasonTitleAndDescriptionBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public DiagReasonTitleAndDescriptionBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public DiagReasonTitleAndDescription build() {
            return new DiagReasonTitleAndDescription(title, description);
        }
    }
}
