package ru.yandex.direct.core.entity.moderationreason.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.i18n.Language;

@ParametersAreNonnullByDefault
public class ModerationReasonRequest {
    @Nullable
    @JsonProperty("ids")
    private final String[] tooltipIDs;

    @Nullable
    @JsonProperty("tld")
    private final String tld;

    @Nullable
    @JsonProperty("lang")
    private final Language lang;

    public ModerationReasonRequest() {
        this(null, null, null);
    }
    public ModerationReasonRequest(String[] ids, Language lang) {
        this(ids, null, lang);
    }
    public ModerationReasonRequest(String[] ids, String tld) {
        this(ids, tld, null);
    }
    public ModerationReasonRequest(@Nullable String[] ids, @Nullable String tld, @Nullable Language lang) {
        this.tooltipIDs = ids;
        this.tld = tld;
        this.lang = lang;
    }

    @Nullable
    public String[] getTooltipIDs() {
        return tooltipIDs;
    }

    @Nullable
    public String getTld() {
        return tld;
    }

    @Nullable
    public Language getLang() {
        return lang;
    }
}
