package ru.yandex.direct.core.entity.moderationreason.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiag;

@ParametersAreNonnullByDefault
public final class ModerationReasonWithDetails {
    private final Long diagId;
    private final Long objectId;
    private final Long bannerId;
    private final ModerationReasonObjectType type;

    @Nullable
    private final String diagText;

    @Nullable
    private final String shortText;

    @Nullable
    private final String token;

    @Nullable
    private final String comment;

    @Nullable
    private final List<String> screenshots;

    public static List<ModerationReasonWithDetails> fromModerationReason(
            ModerationReason modReason, Map<Long, ModerationDiag> diags, @Nullable Set<Long> bannerIds
    ) {
        if (bannerIds == null || bannerIds.size() == 0) {
            return List.of();
        }

        return modReason
                .getReasons()
                .stream()
                .flatMap(detailedReason -> bannerIds.stream().map(bannerId -> ModerationReasonWithDetails.fromReasonsAndDiag(
                        bannerId,
                        modReason,
                        detailedReason,
                        diags.get(detailedReason.getId())
                )))
                .collect(Collectors.toList());
    }

    public static ModerationReasonWithDetails fromReasonsAndDiag(
            Long bannerId,
            ModerationReason modReason,
            ModerationReasonDetailed modReasonDetailed,
            @Nullable ModerationDiag diag
    ) {
        return new ModerationReasonWithDetails(
                modReasonDetailed.getId(),
                modReason.getObjectId(),
                bannerId,
                modReason.getObjectType(),
                diag != null ? diag.getDiagText() : null,
                diag != null ? diag.getShortText() : null,
                diag != null ? diag.getToken() : null,
                modReasonDetailed.getComment(),
                modReasonDetailed.getScreenshots()
        );
    }

    public ModerationReasonWithDetails(
            Long diagId,
            Long objectId,
            Long bannerId,
            ModerationReasonObjectType type,
            @Nullable String diagText,
            @Nullable String shortText,
            @Nullable String token,
            @Nullable String comment,
            @Nullable List<String> screenshots
    ) {
        this.diagId = diagId;
        this.objectId = objectId;
        this.bannerId = bannerId;
        this.type = type;
        this.diagText = diagText;
        this.shortText = shortText;
        this.token = token;
        this.comment = comment;
        this.screenshots = screenshots;
    }

    public Long getDiagId() {
        return diagId;
    }

    public Long getObjectId() {
        return objectId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public ModerationReasonObjectType getType() {
        return type;
    }

    @Nullable
    public String getDiagText() {
        return diagText;
    }

    @Nullable
    public String getShortText() {
        return shortText;
    }

    @Nullable
    public String getToken() {
        return token;
    }

    @Nullable
    public String getComment() {
        return comment;
    }

    @Nullable
    public List<String> getScreenshots() {
        return screenshots;
    }
}
