package ru.yandex.direct.core.entity.moderationreason.model;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagData;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ModerationReportResponse {
    @JsonProperty("manager_info")
    private ManagerInfo managerInfo;
    @JsonProperty("agency_info")
    private AgencyInfo agencyInfo;
    @JsonProperty("agency_manager")
    private AgencyManager agencyManager;
    @JsonProperty("bid")
    private String bid;
    @JsonProperty("vcard_id")
    private String vcardId;
    @JsonProperty("banner_diags")
    private Map<String, List<ModerationDiagData>> bannerDiags = new LinkedHashMap<>();
    @JsonProperty("callout_diags")
    private Map<Long, List<ModerationDiagData>> calloutDiags;
    @JsonProperty("creatives_diags")
    private List<ModerationDiagData> creativesDiags;
    @JsonProperty("bad_sitelinks")
    private Map<String, List<ModerationDiagData>> badSitelinks;
    @JsonProperty("bad_display_href")
    private Map<String, List<ModerationDiagData>> badDisplayHref;
    @JsonProperty("bad_turbolandings")
    private Map<String, List<ModerationDiagData>> badTurbolandings;
    @JsonProperty("bad_images")
    private Map<Long, Map<String, Object>> imageMap;
    @JsonProperty("bad_phrases")
    private Map<BigInteger, String> badPhrases;

    public ManagerInfo getManagerInfo() {
        return managerInfo;
    }

    public void setManagerInfo(ManagerInfo managerInfo) {
        this.managerInfo = managerInfo;
    }

    public AgencyInfo getAgencyInfo() {
        return agencyInfo;
    }

    public void setAgencyInfo(AgencyInfo agencyInfo) {
        this.agencyInfo = agencyInfo;
    }

    public AgencyManager getAgencyManager() {
        return agencyManager;
    }

    public void setAgencyManager(AgencyManager agencyManager) {
        this.agencyManager = agencyManager;
    }

    public String getBid() {
        return bid;
    }

    public void setBid(String bid) {
        this.bid = bid;
    }

    public String getVcardId() {
        return vcardId;
    }

    public void setVcardId(String vcardId) {
        this.vcardId = vcardId;
    }

    public Map<String, List<ModerationDiagData>> getBannerDiags() {
        return bannerDiags;
    }

    public void setBannerDiags(Map<String, List<ModerationDiagData>> bannerDiags) {
        this.bannerDiags = bannerDiags;
    }

    public Map<Long, List<ModerationDiagData>> getCalloutDiags() {
        return calloutDiags;
    }

    public void setCalloutDiags(
            Map<Long, List<ModerationDiagData>> calloutDiags) {
        this.calloutDiags = calloutDiags;
    }

    public List<ModerationDiagData> getCreativesDiags() {
        return creativesDiags;
    }

    public void setCreativesDiags(
            List<ModerationDiagData> creativesDiags) {
        this.creativesDiags = creativesDiags;
    }

    public Map<String, List<ModerationDiagData>> getBadSitelinks() {
        return badSitelinks;
    }

    public void setBadSitelinks(
            Map<String, List<ModerationDiagData>> badSitelinks) {
        this.badSitelinks = badSitelinks;
    }

    public Map<String, List<ModerationDiagData>> getBadDisplayHref() {
        return badDisplayHref;
    }

    public void setBadDisplayHref(
            Map<String, List<ModerationDiagData>> badDisplayHref) {
        this.badDisplayHref = badDisplayHref;
    }

    public Map<String, List<ModerationDiagData>> getBadTurbolandings() {
        return badTurbolandings;
    }

    public void setBadTurbolandings(
            Map<String, List<ModerationDiagData>> badTurbolandings) {
        this.badTurbolandings = badTurbolandings;
    }

    public Map<Long, Map<String, Object>> getImageMap() {
        return imageMap;
    }

    public void setImageMap(Map<Long, Map<String, Object>> imageMap) {
        this.imageMap = imageMap;
    }

    public Map<BigInteger, String> getBadPhrases() {
        return badPhrases;
    }

    public void setBadPhrases(Map<BigInteger, String> badPhrases) {
        this.badPhrases = badPhrases;
    }

    public ModerationReportResponse withManagerInfo(
            ManagerInfo managerInfo) {
        this.managerInfo = managerInfo;
        return this;
    }

    public ModerationReportResponse withAgencyInfo(
            AgencyInfo agencyInfo) {
        this.agencyInfo = agencyInfo;
        return this;
    }

    public ModerationReportResponse withAgencyManager(
            AgencyManager agencyManager) {
        this.agencyManager = agencyManager;
        return this;
    }

    public ModerationReportResponse withBid(String bid) {
        this.bid = bid;
        return this;
    }

    public ModerationReportResponse withVcardId(String vcardId) {
        this.vcardId = vcardId;
        return this;
    }

    public ModerationReportResponse withBannerDiags(Map<String, List<ModerationDiagData>> bannerDiags) {
        this.bannerDiags = bannerDiags;
        return this;
    }

    public ModerationReportResponse withCalloutDiags(
            Map<Long, List<ModerationDiagData>> calloutDiags) {
        this.calloutDiags = calloutDiags;
        return this;
    }

    public ModerationReportResponse withCreativesDiags(
            List<ModerationDiagData> creativesDiags) {
        this.creativesDiags = creativesDiags;
        return this;
    }

    public ModerationReportResponse withBadSitelinks(
            Map<String, List<ModerationDiagData>> badSitelinks) {
        this.badSitelinks = badSitelinks;
        return this;
    }

    public ModerationReportResponse withBadDisplayHref(
            Map<String, List<ModerationDiagData>> badDisplayHref) {
        this.badDisplayHref = badDisplayHref;
        return this;
    }

    public ModerationReportResponse withBadTurbolandings(
            Map<String, List<ModerationDiagData>> badTurbolandings) {
        this.badTurbolandings = badTurbolandings;
        return this;
    }

    public ModerationReportResponse withImageMap(
            Map<Long, Map<String, Object>> imageMap) {
        this.imageMap = imageMap;
        return this;
    }

    public ModerationReportResponse withBadPhrases(Map<BigInteger, String> badPhrases) {
        this.badPhrases = badPhrases;
        return this;
    }

}
