package ru.yandex.direct.core.entity.moderationreason.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.model.ClientWithUsers;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.moderationreason.model.AgencyInfo;
import ru.yandex.direct.core.entity.moderationreason.model.AgencyManager;
import ru.yandex.direct.core.entity.moderationreason.model.ManagerInfo;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReportResponse;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.repository.UserRepository;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

import static java.util.Collections.singletonList;

@Service
class AgencyInfoService {

    private final CampaignRepository campaignRepository;
    private final ShardHelper shardHelper;
    private final UserRepository userRepository;
    private final ClientService clientService;
    private final UserService userService;

    @Autowired
    AgencyInfoService(CampaignRepository campaignRepository,
                      ShardHelper shardHelper, UserRepository userRepository,
                      ClientService clientService, UserService userService) {
        this.campaignRepository = campaignRepository;
        this.shardHelper = shardHelper;
        this.userRepository = userRepository;
        this.clientService = clientService;
        this.userService = userService;
    }

    void fillBannerAgencyInfo(ClientId clientId, ModerationReportResponse moderationReportResponse, Long campaignId) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        List<Campaign> campaigns =
                campaignRepository.getCampaigns(shard, singletonList(campaignId));
        if (campaigns.isEmpty()) {
            return;
        }
        Campaign campaign = campaigns.get(0);
        if (campaign.getAgencyId() != null && campaign.getAgencyId() > 0) {
            ClientWithUsers agency = clientService.massGetClientWithUsers(singletonList(campaign.getAgencyId())).get(0);
            AgencyInfo agencyInfo = new AgencyInfo()
                    .withCountryRegionId(String.valueOf(agency.getCountryRegionId()))
                    .withEmail(agency.getUsers().get(0).getEmail());

            AgencyManager agencyManager = null;
            if (agency.getPrimaryManagerUid() != null && agency.getPrimaryManagerUid() > 0) {
                User user = userService.getUser(agency.getPrimaryManagerUid());
                agencyManager = transformUserToAgencyManager(user);
            }
            moderationReportResponse.setAgencyInfo(agencyInfo);
            moderationReportResponse.setAgencyManager(agencyManager);

        }
        if (campaign.getManagerUserId() != null && campaign.getManagerUserId() > 0) {
            ManagerInfo managerInfo = new ManagerInfo();
            managerInfo.setEmail(userRepository.getUserEmail(shard, campaign.getManagerUserId()));
            moderationReportResponse.setManagerInfo(managerInfo);
        }
    }

    private static AgencyManager transformUserToAgencyManager(User user) {
        if (user != null) {
            return new AgencyManager()
                    .withEmail(user.getEmail())
                    .withFio(user.getFio())
                    .withLogin(user.getLogin())
                    .withSpecialType(SpecialAgencyManagerService.getSpecialManagerType(user.getId()));
        }
        return null;
    }
}
