package ru.yandex.direct.core.entity.moderationreason.service;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.moderationdiag.ModerationDiagDataConverterKt;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiag;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagData;
import ru.yandex.direct.utils.HashingUtils;

public class ModerationDiagConverter {

    private ModerationDiagConverter() {
    }

    public static <T> Map<T, List<ModerationDiagData>> convertMap(Map<T, List<ModerationDiag>> map) {
        return EntryStream.of(map).mapValues(ModerationDiagDataConverterKt::convertList).toMap();
    }

    public static Map<BigInteger, String> badPhrasesConverter(List<Keyword> keywords) {
        return StreamEx.of(keywords).toMap(k -> HashingUtils.getMd5HashUtf8(k.getPhrase()), Keyword::getPhrase);
    }

    public static List<Long> stringToLongList(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return null;
        }
        return Arrays.stream(str.split(",")).
                map(String::trim).
                map(Long::valueOf).collect(Collectors.toList());
    }
}
