package ru.yandex.direct.core.entity.moderationreason.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import ru.yandex.direct.core.entity.moderationreason.model.ModerationReportResponse;
import ru.yandex.direct.dbutil.model.ClientId;

public interface ModerationReasonAggregator {
    Optional<ModerationReportResponse> showDiags(
            long operatorUid, ClientId clientId,
            List<Long> creativeRejectionReasonIds, List<Long> additionsItemIds, Long bannerId
    );

    class FakeModerationReasonAggregator implements ModerationReasonAggregator {
        private final Map<Long, Optional<ModerationReportResponse>> moderationResponseByBid;

        public FakeModerationReasonAggregator(Map<Long, Optional<ModerationReportResponse>> moderationResponseByBid) {
            this.moderationResponseByBid = moderationResponseByBid;
        }

        @Override
        public Optional<ModerationReportResponse> showDiags(long operatorUid, ClientId clientId,
                                                            List<Long> creativeRejectionReasonIds,
                                                            List<Long> additionsItemIds, Long bannerId) {
            return moderationResponseByBid.getOrDefault(bannerId, Optional.empty());
        }
    }
}
