package ru.yandex.direct.core.entity.moderationreason.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacService;

import static java.util.Collections.singletonList;

@Service
class PermissionService {
    private final RbacService rbacService;

    @Autowired
    PermissionService(RbacService rbacService) {
        this.rbacService = rbacService;
    }

    boolean operatorHasPermission(long operatorUid, ClientId clientId, BannerWithSystemFields banner) {
        return rbacService
                .getVisibleCampaigns(operatorUid, singletonList(banner.getCampaignId()))
                .contains(banner.getCampaignId())
                && operatorHasPermission(operatorUid, clientId);
    }

    boolean operatorHasPermission(long operatorUid, ClientId clientId) {
        return rbacService.canRead(operatorUid, rbacService.getChiefByClientId(clientId));
    }
}
