package ru.yandex.direct.core.entity.moderationreason.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;


class SpecialAgencyManagerService {
    private static Map<Long, String> typeByAgencyIdMap = new HashMap<>();

    static {
        Map<String, Set<Long>> agencyMapper = new HashMap<>();
        agencyMapper.put("self_agency", initSelfAgency());
        agencyMapper.put("self_agency_ua", initSelfAgencyUa());
        agencyMapper.put("self_agency_tr", initSelfAgencyTr());
        agencyMapper.put("self_agency_cis", initSelfAgencyCis());
        agencyMapper.forEach(SpecialAgencyManagerService::fillIndex);
    }

    private SpecialAgencyManagerService() {
    }

    private static void fillIndex(String name, Set<Long> ids) {
        for (Long id : ids) {
            typeByAgencyIdMap.put(id, name);
        }
    }

    static String getSpecialManagerType(Long managerId) {
        return typeByAgencyIdMap.get(managerId);
    }

    private static Set<Long> initSelfAgency() {
        Set<Long> agency = new HashSet<>();
        agency.add(41329487L);  //   artem-zateev
        agency.add(89550209L);  //   dushkin-vit
        agency.add(226541728L); //   yndx-infedorova
        agency.add(395174907L); //   yndx-kleimenova-manager-1
        agency.add(173179219L); //   yndx-kozhanova-manager
        agency.add(282597286L); //   yndx-kozlikin
        agency.add(242059493L); //   yndx-mlugar
        agency.add(386870987L); //   yndx-m-salina-manager
        agency.add(330055775L); //   yndx-shtan15
        agency.add(398821980L); //   yndx-yazhevika
        agency.add(222344052L); //   yndx-tonymineev
        agency.add(247053843L); //   yndx-popovskikh
        return agency;
    }

    private static Set<Long> initSelfAgencyUa() {
        Set<Long> agency = new HashSet<>();
        agency.add(176441802L); //   yndx-andsv-manager
        agency.add(312612842L); //   yndx-perishkova-manager
        return agency;
    }

    private static Set<Long> initSelfAgencyTr() {
        Set<Long> agency = new HashSet<>();
        agency.add(277371208L); //   yndx-sedletskaya-manager
        return agency;
    }

    private static Set<Long> initSelfAgencyCis() {
        Set<Long> agency = new HashSet<>();
        agency.add(166169808L); //   yndx-kolesnicova
        agency.add(321056438L); //   yndx-vecher-manager
        return agency;
    }
}
