package ru.yandex.direct.core.entity.monitoring;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.monitoring.model.CompareType;
import ru.yandex.direct.core.entity.monitoring.model.LogStringExistsMonitoringMethodConfig;
import ru.yandex.direct.core.entity.monitoring.model.LoggingMonitoringMethodNotifierConfig;
import ru.yandex.direct.core.entity.monitoring.model.MonitoringMethodConfig;
import ru.yandex.direct.core.entity.monitoring.model.ThresholdMonitoringMethodConfig;

@Repository
public class MonitoringConfigRepository {

    public static final String DEFAULT_METHOD_NAME = "_default";

    public Map<String, List<MonitoringMethodConfig>> getMonitoringMethodConfigs() {
        return Map.of("traceLogTimeSpendMonitoringDataProcessor",
                List.of(new ThresholdMonitoringMethodConfig("direct.web", "grid.api.CampaignsQuery",
                                "traceLogTimeSpendMonitoringDataProcessor",
                                List.of(new LoggingMonitoringMethodNotifierConfig("loggingMonitoringNotifier")),
                                false, 30,
                                "percentile95MonitoringFunction",
                                CompareType.GREATER, -0.00001),
                        new ThresholdMonitoringMethodConfig("direct.web", "alive",
                                "traceLogTimeSpendMonitoringDataProcessor",
                                List.of(new LoggingMonitoringMethodNotifierConfig("loggingMonitoringNotifier")),
                                false, 30,
                                "percentile95MonitoringFunction",
                                CompareType.GREATER, -0.00003),
                        new ThresholdMonitoringMethodConfig("direct.web", DEFAULT_METHOD_NAME,
                                "traceLogTimeSpendMonitoringDataProcessor",
                                List.of(new LoggingMonitoringMethodNotifierConfig("loggingMonitoringNotifier")),
                                false, 30,
                                "percentile95MonitoringFunction",
                                CompareType.GREATER, -0.3)),
                "traceLogFunctionNameExistMonitoringDataProcessor",
                List.of(
                        new LogStringExistsMonitoringMethodConfig("direct.web", DEFAULT_METHOD_NAME,
                                "traceLogFunctionNameExistMonitoringDataProcessor",
                                List.of(new LoggingMonitoringMethodNotifierConfig("loggingMonitoringNotifier")),
                                false,
                                "db:read",
                                false))
        );
    }

    public Set<String> getAllServices() {
        return Set.of("direct.web");
    }
}
