package ru.yandex.direct.core.entity.motivationmail;

import java.time.LocalDateTime;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Service
public class MotivationMailService {
    private final MotivationMailRepository motivationMailRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public MotivationMailService(MotivationMailRepository motivationMailRepository, ShardHelper shardHelper) {
        this.motivationMailRepository = motivationMailRepository;
        this.shardHelper = shardHelper;
    }


    public void updateNotificationInfo(long clientId, MotivationMailNotificationType notification, LocalDateTime notificationTime) {
        int shard = shardHelper.getShardByClientIdStrictly(ClientId.fromLong(clientId));
        motivationMailRepository.updateNotificationInfo(shard, clientId, notification, notificationTime);
    }
}
