package ru.yandex.direct.core.entity.motivationmail;

import java.time.LocalDateTime;
import java.util.Objects;

public class MotivationMailStats {
    private final Long clientId;
    private final MotivationMailNotificationType lastSentNotification;
    private final LocalDateTime lastSentTime;
    private final Integer newCampsCount;
    private final Integer acceptedCampsCount;
    private final Integer nonzeroMoneyCampsCount;
    private final ClientType clientType;

    public MotivationMailStats(Long clientId,
                               MotivationMailNotificationType lastSentNotification,
                               LocalDateTime lastSentTime, Integer newCampsCount,
                               Integer acceptedCampsCount, Integer nonzeroMoneyCampsCount,
                               ClientType clientType) {
        this.clientId = clientId;
        this.lastSentNotification = lastSentNotification;
        this.lastSentTime = lastSentTime;
        this.newCampsCount = newCampsCount;
        this.acceptedCampsCount = acceptedCampsCount;
        this.nonzeroMoneyCampsCount = nonzeroMoneyCampsCount;
        this.clientType = clientType;
    }

    public Long getClientId() {
        return clientId;
    }

    public Integer getNewCampsCount() {
        return newCampsCount;
    }

    public Integer getAcceptedCampsCount() {
        return acceptedCampsCount;
    }

    public Integer getNonzeroMoneyCampsCount() {
        return nonzeroMoneyCampsCount;
    }

    public MotivationMailNotificationType getLastSentNotification() {
        return lastSentNotification;
    }

    public LocalDateTime getLastSentTime() {
        return lastSentTime;
    }

    public ClientType getClientType() {
        return clientType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MotivationMailStats that = (MotivationMailStats) o;
        return Objects.equals(clientId, that.clientId) &&
                lastSentNotification == that.lastSentNotification &&
                Objects.equals(lastSentTime, that.lastSentTime) &&
                Objects.equals(newCampsCount, that.newCampsCount) &&
                Objects.equals(acceptedCampsCount, that.acceptedCampsCount) &&
                Objects.equals(nonzeroMoneyCampsCount, that.nonzeroMoneyCampsCount) &&
                Objects.equals(clientType, that.clientType);
    }

    @Override
    public int hashCode() {

        return Objects.hash(clientId, lastSentNotification, lastSentTime, newCampsCount, acceptedCampsCount,
                nonzeroMoneyCampsCount, clientType);
    }

    /**
     * В каком интерфейсе клиент прошёл регистрацию
     */
    public enum ClientType {
        DESKTOP,
        TOUCH
    }
}
