package ru.yandex.direct.core.entity.multipliers.repository;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncItem;
import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;
import static ru.yandex.direct.dbschema.ppc.tables.RetargetingMultiplierValues.RETARGETING_MULTIPLIER_VALUES;

@Repository
public class MultipliersRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public MultipliersRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Получить список номеров кампаний и групп, в коэффициентах у которых используется один из retCondIds
     *
     * @param shard
     * @param retCondIds
     * @param priority   приоритет для проставления в бин, чтобы потом можно было сразу записать в очередь
     * @return
     */
    public Collection<BsResyncItem> getAdgroupIdsByRetargeting(int shard, Collection<Long> retCondIds,
                                                               BsResyncPriority priority) {
        return dslContextProvider.ppc(shard)
                .selectDistinct(HIERARCHICAL_MULTIPLIERS.CID, HIERARCHICAL_MULTIPLIERS.PID)
                .from(RETARGETING_MULTIPLIER_VALUES)
                .join(HIERARCHICAL_MULTIPLIERS)
                .on(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID
                        .eq(RETARGETING_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID))
                .where(RETARGETING_MULTIPLIER_VALUES.RET_COND_ID.in(retCondIds))
                .fetch(rec -> new BsResyncItem(priority, rec.value1(), null, rec.value2()));
    }

}
