package ru.yandex.direct.core.entity.music;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.audio.model.AudioGenreBase;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppcdict.tables.AudioGenres.AUDIO_GENRES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

/**
 * Получение аудио жанров
 */

@Repository
public class AudioGenreRepository {
    public final JooqMapperWithSupplier<AudioGenreBase> mapper;
    private final DslContextProvider dslContextProvider;

    @Autowired
    public AudioGenreRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.mapper = createMapper();
    }

    /**
     * Получить справочник жанров
     *
     * @return {@link Map} список жанров по идентификатору
     */
    public Map<Long, AudioGenreBase> getAll() {
        return dslContextProvider.ppcdict()
                .select(mapper.getFieldsToRead())
                .from(AUDIO_GENRES)
                .fetchMap(AUDIO_GENRES.ID, mapper::fromDb);
    }

    private JooqMapperWithSupplier<AudioGenreBase> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(AudioGenreBase::new)
                .map(property(AudioGenreBase.ID, AUDIO_GENRES.ID))
                .map(property(AudioGenreBase.PARENT_ID, AUDIO_GENRES.PARENT_ID))
                .map(property(AudioGenreBase.NAME, AUDIO_GENRES.NAME))
                .map(property(AudioGenreBase.TANKER_NAME_KEY, AUDIO_GENRES.TANKER_NAME_KEY))
                .map(property(AudioGenreBase.TANKER_DESCRIPTION_KEY, AUDIO_GENRES.TANKER_DESCRIPTION_KEY))
                .map(property(AudioGenreBase.KEYWORD, AUDIO_GENRES.BB_KEYWORD))
                .map(property(AudioGenreBase.KEYWORD_VALUE, AUDIO_GENRES.BB_KEYWORD_VALUE))
                .build();
    }
}
