package ru.yandex.direct.core.entity.notification;

import java.util.Locale;
import java.util.Set;


import javax.annotation.Nonnull;

import ru.yandex.direct.i18n.Language;

public final class LocaleResolver {
    public static final Set<Language> SUPPORTED_LANGUAGES = Set.of(Language.EN, Language.RU, Language.TR);

    @Nonnull
    public static final Language getLanguageWithFallback(Language language) {
        return SUPPORTED_LANGUAGES.contains(language) ? language : Language.RU;
    }

    public static final Locale getLocaleByLanguageWithFallback(Language language) {
        return Locale.forLanguageTag(getLanguageWithFallback(language).getLangString());
    }
}
