package ru.yandex.direct.core.entity.notification;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.notification.container.Notification;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.intapi.client.IntApiClient;

import static com.google.common.base.Preconditions.checkState;

/**
 * Сервис для отправки уведомлений. Не предназначен для работы в песочнице
 * Для отправки используется интапи-ручка Notification
 *
 * @see IntApiClient
 */
@ParametersAreNonnullByDefault
public class NotificationServiceIntapiImpl implements NotificationService {
    private final IntApiClient intApiClient;

    @Autowired
    public NotificationServiceIntapiImpl(IntApiClient intApiClient, EnvironmentType environmentType) {
        checkState(!environmentType.isSandbox(), "Сервис не предназначен для работы в песочнице");
        this.intApiClient = intApiClient;
    }

    /**
     * Отправляет нотификацию через perl-intapi Директа
     *
     * @param notification нотификация для отправки
     */
    @Override
    public void addNotification(Notification notification) {
        intApiClient.addNotification(notification.getNotificationType().getNotificationName(),
                notification.getNotificationData(),
                notification.getNotificationParams()
        );
    }
}
