package ru.yandex.direct.core.entity.notification.container;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Map.entry;

@ParametersAreNonnullByDefault
public class BlockedClientNotification implements Notification {

    private ClientId clientId;

    public ClientId getClientId() {
        return clientId;
    }

    public BlockedClientNotification withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.BLOCKED_CLIENT;
    }

    @Override
    public Map<String, Object> getNotificationData() {
        return Map.ofEntries(
                entry("ClientID", clientId.asLong())
        );
    }

    @Override
    public Map<String, Object> getNotificationParams() {
        return Map.ofEntries(
                entry("init_manager_uid", 1),
                entry("init_ag_manager_uid", 1)
        );
    }

}
