package ru.yandex.direct.core.entity.notification.container;

import java.util.Map;

import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Map.entry;

public class BroadMatchUncheckNotification implements Notification {

    private Long campaignId;
    private Long managerUid;
    private String clientLogin;
    private ClientId clientId;

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.BROAD_MATCH_UNCHECK;
    }

    @Override
    public Map<String, Object> getNotificationData() {
        return Map.ofEntries(
                entry("cid", campaignId),
                entry("ManagerUID", managerUid),
                entry("client_login", clientLogin),
                entry("client_id", clientId.asLong())
        );
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public BroadMatchUncheckNotification withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getManagerUid() {
        return managerUid;
    }

    public BroadMatchUncheckNotification withManagerUid(Long managerUid) {
        this.managerUid = managerUid;
        return this;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public BroadMatchUncheckNotification withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public BroadMatchUncheckNotification withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }
}
