package ru.yandex.direct.core.entity.notification.container;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * Модель для отправки уведомления CAMP_FINISHED_WO_EVENTLOG письмом и смс
 */
public class CampFinishedMailNotification implements Notification {
    private Long campaignId;
    private String campaignName;
    private LocalDate finishDate;
    private Long clientId;
    private Long clientUserId;
    private String clientFullName;
    private String clientLogin;
    private String clientPhone;
    private String clientEmail;
    private String clientLang;
    private Long agencyUid;

    @Override
    public Map<String, Object> getNotificationData() {
        Map<String, Object> campData = new HashMap<>();
        campData.put("cid", campaignId);
        campData.put("finish_date", finishDate.toString());
        campData.put("name", campaignName);
        campData.put("ClientID", clientId);
        campData.put("AgencyUID", agencyUid);

        Map<String, Object> userData = new HashMap<>();
        userData.put("uid", clientUserId);
        userData.put("email", clientEmail);
        userData.put("FIO", clientFullName);
        userData.put("login", clientLogin);
        userData.put("phone", clientPhone);
        userData.put("lang", clientLang);

        Map<String, Object> data = new HashMap<>();
        data.put("campaign", campData);
        data.put("user", userData);
        return Collections.unmodifiableMap(data);
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.CAMP_FINISHED_WO_EVENTLOG;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public CampFinishedMailNotification withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public CampFinishedMailNotification withCampaignName(String campaignName) {
        this.campaignName = campaignName;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public CampFinishedMailNotification withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getClientUserId() {
        return clientUserId;
    }

    public void setClientUserId(Long clientUserId) {
        this.clientUserId = clientUserId;
    }

    public CampFinishedMailNotification withClientUserId(Long clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    public String getClientFullName() {
        return clientFullName;
    }

    public void setClientFullName(String clientFullName) {
        this.clientFullName = clientFullName;
    }

    public CampFinishedMailNotification withClientFullName(String clientFullName) {
        this.clientFullName = clientFullName;
        return this;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public void setClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
    }

    public CampFinishedMailNotification withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public String getClientPhone() {
        return clientPhone;
    }

    public void setClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
    }

    public CampFinishedMailNotification withClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
        return this;
    }

    public String getClientEmail() {
        return clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public CampFinishedMailNotification withClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
        return this;
    }

    public LocalDate getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(LocalDate finishDate) {
        this.finishDate = finishDate;
    }

    public CampFinishedMailNotification withFinishDate(LocalDate finishDate) {
        this.finishDate = finishDate;
        return this;
    }

    public String getClientLang() {
        return clientLang;
    }

    public void setClientLang(String clientLang) {
        this.clientLang = clientLang;
    }

    public CampFinishedMailNotification withClientLang(String clientLang) {
        this.clientLang = clientLang;
        return this;
    }

    public CampFinishedMailNotification withAgencyUid(Long agencyUid) {
        this.agencyUid = agencyUid;
        return this;
    }
}
