package ru.yandex.direct.core.entity.notification.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import ru.yandex.direct.core.entity.banner.model.BidGroup;

/**
 * Модель для отправки уведомления NEW_DOMAINS письмом
 */
public class NewDomainMailNotification implements Notification {

    private String fio;
    private Long agencyUserId;
    private Collection<BidGroup> bidGroups;

    @Override
    public Map<String, Object> getNotificationData() {

        Collection<Map<String, Object>> bidGroupsData = new ArrayList<>();
        for (BidGroup bidGroup : bidGroups) {
            Map<String, Object> bidGroupData = new HashMap<>();
            bidGroupData.put("bids", bidGroup.getBids());
            bidGroupData.put("cid", bidGroup.getCampaignId());
            bidGroupData.put("domain", bidGroup.getDomain());
            bidGroupData.put("fio", bidGroup.getFio());
            bidGroupData.put("uid", bidGroup.getClientUserId());

            bidGroupsData.add(bidGroupData);
        }

        Map<String, Object> data = new HashMap<>();
        data.put("bids_grouped", bidGroupsData);
        data.put("fio", fio);
        data.put("for_agency", 1);
        data.put("uid", agencyUserId);

        return Collections.unmodifiableMap(data);
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.NEW_DOMAINS;
    }

    public String getFio() {
        return fio;
    }

    public void setFio(String fio) {
        this.fio = fio;
    }

    public Long getAgencyUserId() {
        return agencyUserId;
    }

    public void setAgencyUserId(Long agencyUserId) {
        this.agencyUserId = agencyUserId;
    }

    public Collection<BidGroup> getBidGroups() {
        return bidGroups;
    }

    public void setBidGroups(
            Collection<BidGroup> bidGroups) {
        this.bidGroups = bidGroups;
    }

    public NewDomainMailNotification withFio(String fio) {
        this.fio = fio;
        return this;
    }

    public NewDomainMailNotification withAgencyUserId(Long agencyUserId) {
        this.agencyUserId = agencyUserId;
        return this;
    }

    public NewDomainMailNotification withBidGroups(
            Collection<BidGroup> bidGroups) {
        this.bidGroups = bidGroups;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        NewDomainMailNotification that = (NewDomainMailNotification) o;
        return Objects.equals(fio, that.fio)
                && Objects.equals(agencyUserId, that.agencyUserId)
                && Objects.equals(bidGroups, that.bidGroups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                fio,
                agencyUserId,
                bidGroups
        );
    }

}
