package ru.yandex.direct.core.entity.notification.container;

import java.util.Collections;
import java.util.Map;

/**
 * Данные необходимые для отправки уведомлений
 */
public interface Notification {

    /**
     * @return Тип уведомления
     */
    NotificationType getNotificationType();

    /**
     * @return Данные уведомления
     */
    Map<String, Object> getNotificationData();

    /**
     * @return Параметры уведомления. По умолчанию параметров нет
     */
    default Map<String, Object> getNotificationParams() {
        return Collections.emptyMap();
    }
}
