package ru.yandex.direct.core.entity.notification.container;

/**
 * Типы уведомлений. Все типы перечислены в перловом модуле Notification в хэше %NOTIFICATION
 * Элементы этого перечисления - это uppercase имен уведомлений из перлового директа.
 *
 * @see <a href="https://svn.yandex-team.ru/websvn/wsvn/direct/trunk/protected/Notification.pm">Notification</a>
 */
public enum NotificationType {
    NEW_DOMAINS,
    OPTIMIZATION_RESULT,
    NOTIFY_ORDER_MONEY_IN_WO_EVENTLOG,
    NOTIFY_ORDER_MONEY_OUT_BLOCKING,
    CAMP_FINISHED_WO_EVENTLOG,
    /**
     * Тип нотификации
     * Отправляет письмо и смс (если нужно) об остановке/возобновлении показов мониторингом доступности доменов.
     * <pre>
     * {@code
     *
     *     {
     *         uid =>  ...,            # кому отправлять письмо/смс
     *         ClientID => ...,        # для футера
     *         state => "dead/alive",  # уведомление об остановке или возобновлении
     *         domain_list => [...],   # список доменов о которых уведомляем
     *         camp_list => [          # список кампаний, о которых уведомляем
     *           {
     *             cid => ...,
     *             name => ...,        # название кампании
     *           },
     *           ...
     *         ],
     *     }
     * }
     * </pre>
     * <a href="https://svn.yandex-team.ru/websvn/wsvn/direct/trunk/protected/Notification.pm?op=blame&rev=171959#l1002">Источник</a>
     */
    BS_MONITOR_BANNER,
    YA_AGENCY_ORDER_PAID,
    MOBILE_CONTENT_MONITORING,
    AUTO_SERVICING,
    SERVICING_REQUEST,
    NEW_CAMP_INFO,
    BROAD_MATCH_UNCHECK,
    BLOCKED_CLIENT,
    ;

    public String getNotificationName() {
        return name().toLowerCase();
    }
}
