package ru.yandex.direct.core.entity.notification.container;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.currency.Money;

/**
 * Модель для отправки уведомления NOTIFY_ORDER_MONEY_IN/NOTIFY_ORDER_MONEY_OUT_BLOCKING письмом и смс
 */
public class NotifyOrderMailNotification implements Notification {
    private final NotificationType notificationType;

    private Long campaignId;
    private String campaignName;
    private CampaignType campaignType;
    private Long walletId;
    private Long clientId;
    private Long clientUserId;
    private String clientFullName;
    private String clientLogin;
    private String clientPhone;
    private String clientEmail;
    private Money sum;
    private Money sumPayed;
    private Money sumPayedOriginal;
    private Boolean withoutNds;
    private BigDecimal sumPayedUnitsRate;
    private BigDecimal nds;
    private Long startTimeTs;
    private Boolean startTimeInFuture;
    private Long agencyUserId;
    private String agencyEmail;
    private NotifyOrderPayType payType;

    public NotifyOrderMailNotification(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    @Override
    public Map<String, Object> getNotificationData() {
        return Collections.unmodifiableMap(new HashMap<String, Object>() {
            {
                put("cid", campaignId);
                put("campaign_id", campaignId);
                put("camp_name", campaignName);
                put("campaign_type", campaignType.toString().toLowerCase());
                put("wallet_cid", walletId);
                put("start_time_ts", startTimeTs);
                put("in_future", startTimeInFuture ? 1 : 0);

                //client info
                put("client_id", clientId);
                put("client_uid", clientUserId);
                put("client_fio", clientFullName);
                put("fio", clientFullName != null ? clientFullName : "");
                put("client_login", clientLogin);
                put("client_phone", clientPhone);
                put("client_email", clientEmail);
                put("agency_uid", agencyUserId);
                put("agency_email", agencyEmail);

                //sum info
                put("sum", sum.bigDecimalValue().toPlainString());
                put("sum_payed", sumPayed.bigDecimalValue().toPlainString());
                put("without_nds", withoutNds ? 1 : 0);
                put("sum_payed_original", sumPayedOriginal.bigDecimalValue().toPlainString());
                put("sum_payed_units_rate", sumPayedUnitsRate.toPlainString());
                put("currency", sum.getCurrencyCode().name());
                put("pay_type", payType.toString().toLowerCase());
            }
        });
    }

    @Override
    public Map<String, Object> getNotificationParams() {
        return Collections.singletonMap("mail_fio_tt_name", "client_fio");
    }

    @Override
    public NotificationType getNotificationType() {
        return notificationType;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public NotifyOrderMailNotification withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public NotifyOrderMailNotification withCampaignName(String camapignName) {
        this.campaignName = camapignName;
        return this;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public void setCampaignType(CampaignType campaignType) {
        this.campaignType = campaignType;
    }

    public NotifyOrderMailNotification withCampaignType(CampaignType camapignType) {
        this.campaignType = camapignType;
        return this;
    }

    public Long getWalletId() {
        return walletId;
    }

    public void setWalletId(Long walletId) {
        this.walletId = walletId;
    }

    public NotifyOrderMailNotification withWalletId(Long walletId) {
        this.walletId = walletId;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public NotifyOrderMailNotification withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getClientUserId() {
        return clientUserId;
    }

    public void setClientUserId(Long clientUserId) {
        this.clientUserId = clientUserId;
    }

    public NotifyOrderMailNotification withClientUserId(Long clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    public String getClientFullName() {
        return clientFullName;
    }

    public void setClientFullName(String clientFullName) {
        this.clientFullName = clientFullName;
    }

    public NotifyOrderMailNotification withClientFullName(String clientFullName) {
        this.clientFullName = clientFullName;
        return this;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public void setClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
    }

    public NotifyOrderMailNotification withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public String getClientPhone() {
        return clientPhone;
    }

    public void setClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
    }

    public NotifyOrderMailNotification withClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
        return this;
    }

    public String getClientEmail() {
        return clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public NotifyOrderMailNotification withClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
        return this;
    }

    public Money getSum() {
        return sum;
    }

    public void setSum(Money sum) {
        this.sum = sum;
    }

    public NotifyOrderMailNotification withSum(Money sum) {
        this.sum = sum;
        return this;
    }

    public Money getSumPayed() {
        return sumPayed;
    }

    public void setSumPayed(Money sumPayed) {
        this.sumPayed = sumPayed;
    }

    public NotifyOrderMailNotification withSumPayed(Money sumPayed) {
        this.sumPayed = sumPayed;
        return this;
    }

    public Long getStartTimeTs() {
        return startTimeTs;
    }

    public void setStartTimeTs(Long startTimeTs) {
        this.startTimeTs = startTimeTs;
    }

    public NotifyOrderMailNotification withStartTimeTs(Long startTimeTs) {
        this.startTimeTs = startTimeTs;
        return this;
    }

    public Boolean getStartTimeInFuture() {
        return startTimeInFuture;
    }

    public void setStartTimeInFuture(Boolean startTimeInFuture) {
        this.startTimeInFuture = startTimeInFuture;
    }

    public NotifyOrderMailNotification withStartTimeInFuture(Boolean startTimeInFuture) {
        this.startTimeInFuture = startTimeInFuture;
        return this;
    }

    public NotifyOrderPayType getPayType() {
        return payType;
    }

    public void setPayType(NotifyOrderPayType payType) {
        this.payType = payType;
    }

    public NotifyOrderMailNotification withPayType(NotifyOrderPayType payType) {
        this.payType = payType;
        return this;
    }

    public Long getAgencyUserId() {
        return agencyUserId;
    }

    public void setAgencyUserId(Long agencyUserId) {
        this.agencyUserId = agencyUserId;
    }

    public NotifyOrderMailNotification withAgencyUserId(Long agencyUserId) {
        this.agencyUserId = agencyUserId;
        return this;
    }

    public String getAgencyEmail() {
        return agencyEmail;
    }

    public void setAgencyEmail(String agencyEmail) {
        this.agencyEmail = agencyEmail;
    }

    public NotifyOrderMailNotification withAgencyEmail(String agencyEmail) {
        this.agencyEmail = agencyEmail;
        return this;
    }

    public BigDecimal getNds() {
        return nds;
    }

    public void setNds(BigDecimal nds) {
        this.nds = nds;
    }

    public NotifyOrderMailNotification withNds(BigDecimal nds) {
        this.nds = nds;
        return this;
    }

    public BigDecimal getSumPayedUnitsRate() {
        return sumPayedUnitsRate;
    }

    public void setSumPayedUnitsRate(BigDecimal sumPayedUnitsRate) {
        this.sumPayedUnitsRate = sumPayedUnitsRate;
    }

    public NotifyOrderMailNotification withSumPayedUnitsRate(BigDecimal sumPayedUnitsRate) {
        this.sumPayedUnitsRate = sumPayedUnitsRate;
        return this;
    }

    public Boolean getWithoutNds() {
        return withoutNds;
    }

    public NotifyOrderMailNotification withWithoutNds(Boolean withoutNds) {
        this.withoutNds = withoutNds;
        return this;
    }

    public Money getSumPayedOriginal() {
        return sumPayedOriginal;
    }

    public void setSumPayedOriginal(Money sumPayedOriginal) {
        this.sumPayedOriginal = sumPayedOriginal;
    }

    public NotifyOrderMailNotification withSumPayedOriginal(Money sumPayedOriginal) {
        this.sumPayedOriginal = sumPayedOriginal;
        return this;
    }
}
