package ru.yandex.direct.core.entity.notification.container;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

/**
 * Уведомление об успешной оплате клиентом услуг Я.Агенства или о том, что оплата не состоялась
 */
public class NotifyPromoOrderMailNotification implements Notification {

    private final long clientId;
    private final int productType;
    private NotificationType notificationType;

    private NotifyPromoOrderMailNotification(NotificationType notificationType, long clientId, int productType) {
        this.clientId = clientId;
        this.productType = productType;
        this.notificationType = notificationType;
    }

    public static NotifyPromoOrderMailNotification success(long clientId, int productType) {
        return new NotifyPromoOrderMailNotification(NotificationType.YA_AGENCY_ORDER_PAID, clientId, productType);
    }

    @Override
    public NotificationType getNotificationType() {
        return notificationType;
    }

    @Override
    public Map<String, Object> getNotificationData() {
        return ImmutableMap.of("client_id", clientId,
                "product_type", productType);
    }
}
