package ru.yandex.direct.core.entity.notification.container;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;

/**
 * Модель для отправки уведомления об готовности заказа "Первой помощи"
 * Все поля должны быть не null, иначе при вызове getNotificationsData() получим NPE - в ImmutableMap.put есть checkEntryNotNull
 */
@ParametersAreNonnullByDefault
public class OptimizationResultNotification implements Notification {

    static final String CAMPAIGN_ID = "cid";
    static final String UID = "uid";
    static final String IS_SECOND_AID = "is_second_aid";
    static final String DAYS_TO_GO = "daystogo";
    static final String FIO = "fio";
    static final String EMAIL = "email";

    private long campaignId;
    private long uid;
    private boolean isSecondAid;
    private int daysToGo;
    private String fio;
    private String email;

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.OPTIMIZATION_RESULT;
    }

    @Override
    public Map<String, Object> getNotificationData() {
        return ImmutableMap.<String, Object>builder()
                .put(CAMPAIGN_ID, campaignId)
                .put(UID, uid)
                .put(IS_SECOND_AID, isSecondAid)
                .put(DAYS_TO_GO, daysToGo)
                .put(FIO, fio)
                .put(EMAIL, email)
                .build();
    }

    public long getCampaignId() {
        return campaignId;
    }

    public long getUid() {
        return uid;
    }

    public boolean isSecondAid() {
        return isSecondAid;
    }

    public int getDaysToGo() {
        return daysToGo;
    }

    public String getFio() {
        return fio;
    }

    public String getEmail() {
        return email;
    }

    public OptimizationResultNotification withCampaignId(long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public OptimizationResultNotification withUid(long uid) {
        this.uid = uid;
        return this;
    }

    public OptimizationResultNotification withSecondAid(boolean secondAid) {
        isSecondAid = secondAid;
        return this;
    }

    public OptimizationResultNotification withDaysToGo(int daysToGo) {
        this.daysToGo = daysToGo;
        return this;
    }

    public OptimizationResultNotification withFio(String fio) {
        this.fio = fio;
        return this;
    }

    public OptimizationResultNotification withEmail(String email) {
        this.email = email;
        return this;
    }
}
