package ru.yandex.direct.core.entity.notification.container;

import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.user.model.User;

import static java.util.Map.entry;

@ParametersAreNonnullByDefault
public class ServicingRequestMailNotification implements Notification {
    private Long campaignId;
    private String campaignName;
    private CampaignType campaignType;
    private User subjectUser;
    private User manager;

    public ServicingRequestMailNotification(Long campaignId, String campaignName, CampaignType campaignType,
                                            User subjectUser, User manager) {
        this.campaignId = campaignId;
        this.campaignName = campaignName;
        this.campaignType = campaignType;
        this.subjectUser = subjectUser;
        this.manager = manager;
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.SERVICING_REQUEST;
    }

    @Override
    public Map<String, Object> getNotificationData() {
        return Map.ofEntries(
                entry("cid", campaignId.toString()),
                entry("campaign_id", campaignId.toString()),
                entry("camp_name", campaignName),
                entry("campaign_name", campaignName),
                entry("campaign_type", CampaignType.toSource(campaignType).getLiteral()),
                entry("manager_uid", manager.getUid().toString()),
                entry("manager_fio", manager.getFio()),
                entry("user_login", subjectUser.getLogin()),
                entry("client_login", subjectUser.getLogin()),
                entry("client_id", subjectUser.getClientId().toString()),
                entry("client_fio", subjectUser.getFio()),
                entry("fio", subjectUser.getFio()),
                entry("client_email", subjectUser.getEmail()),
                entry("client_phone", Optional.ofNullable(subjectUser.getPhone()).orElse(""))
        );
    }
}
