package ru.yandex.direct.core.entity.notification.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.core.entity.campaign.model.CampaignForNotifyUrlMonitoring;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;


/**
 * Модель для отправки уведомления BS_MONITOR_BANNER письмом и смс
 */
public class UrlMonitoringEventNotification implements Notification {
    private Long uid;
    private Long clientId;
    private String login;
    private boolean needSms;
    private String state;
    private Set<String> domains;
    private Map<Long, String> campaigns;

    @Override
    public Map<String, Object> getNotificationData() {
        Map<String, Object> data = new HashMap<>();
        data.put("uid", uid);
        data.put("ClientID", clientId);
        data.put("login", login);
        data.put("state", state);
        data.put("domain_list", domains);

        Set<Map<String, Object>> campData =
                listToSet(mapList(campaigns.entrySet(), c -> ImmutableMap.of("cid", c.getKey(), "name", c.getValue())), identity());

        data.put("camp_list", campData);
        return Collections.unmodifiableMap(data);
    }

    @Override
    public Map<String, Object> getNotificationParams() {
        Map<String, Object> params = new HashMap<>();
        params.put("need_sms", needSms);
        return Collections.unmodifiableMap(params);
    }

    public Long getUid() {
        return uid;
    }

    public UrlMonitoringEventNotification withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public UrlMonitoringEventNotification withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public UrlMonitoringEventNotification withLogin(String login) {
        this.login = login;
        return this;
    }

    public boolean isNeedSms() {
        return needSms;
    }

    public UrlMonitoringEventNotification withNeedSms(boolean needSms) {
        this.needSms = needSms;
        return this;
    }

    public String getState() {
        return state;
    }

    public UrlMonitoringEventNotification withState(String state) {
        this.state = state;
        return this;
    }

    public Set<String> getDomains() {
        return domains;
    }

    public UrlMonitoringEventNotification withDomains(Set<String> domains) {
        this.domains = domains;
        return this;
    }

    public Map<Long, String> getCampaigns() {
        return campaigns;
    }

    public UrlMonitoringEventNotification withCampaigns(
            List<CampaignForNotifyUrlMonitoring> campaigns) {
        this.campaigns = campaigns.stream()
                .collect(toMap(CampaignForNotifyUrlMonitoring::getId, CampaignForNotifyUrlMonitoring::getName,
                        (c1, c2) -> c1));
        return this;
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.BS_MONITOR_BANNER;
    }

}
