package ru.yandex.direct.core.entity.notification.repository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.SmsFlag;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.core.entity.time.model.TimeInterval;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.SmsQueue.SMS_QUEUE;

@Repository
public class SmsQueueRepository {


    private final DslContextProvider dslContextProvider;

    @Autowired
    public SmsQueueRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Помещаем sms сообщение в очередь на отправку. Взятие из очереди и отправка происходит в ppcSendSMS.pl
     */
    public void addToSmsQueue(int shard, Long uid, Long walletId, String message, SmsFlag smsFlag,
                              TimeInterval smsTimeInterval) {
        String smsTime = CampaignMappings.smsTimeToDb(smsTimeInterval);

        dslContextProvider.ppc(shard)
                .insertInto(SMS_QUEUE)
                .columns(SMS_QUEUE.UID, SMS_QUEUE.CID, SMS_QUEUE.SMS_TEXT, SMS_QUEUE.TEMPLATE_NAME, SMS_QUEUE.SMS_TIME)
                .values(uid, walletId, message, smsFlag.name().toLowerCase(), smsTime)
                .execute();
    }
}
