package ru.yandex.direct.core.entity.offerretargeting.repository

import com.google.common.collect.ImmutableMap
import com.google.common.collect.ImmutableSet
import ru.yandex.direct.core.entity.bids.service.BidBaseOpt
import ru.yandex.direct.core.entity.offerretargeting.container.OfferRetargetingModification
import ru.yandex.direct.core.entity.offerretargeting.model.OfferRetargeting
import ru.yandex.direct.jooqmapper.write.PropertyValues
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.model.ModelProperty
import ru.yandex.direct.utils.NumberUtils.isNullOrZero
import java.math.BigDecimal

object OfferRetargetingMapping {
    private val BID_OPTIONS_FLAGS_ENTRIES = ImmutableMap.builder<String, ModelProperty<in OfferRetargeting?, *>>()
        .put(OfferRetargeting.IS_DELETED.name(), OfferRetargeting.IS_DELETED)
        .put(OfferRetargeting.IS_SUSPENDED.name(), OfferRetargeting.IS_SUSPENDED)
        .build()

    val BID_OPTION_FLAGS: ImmutableSet<ModelProperty<in OfferRetargeting?, *>> =
        ImmutableSet.copyOf(BID_OPTIONS_FLAGS_ENTRIES.values)

    fun offerRetargetingPropsToDbOpts(propertyValues: PropertyValues<OfferRetargeting>): String =
        sequenceOf(
            if (propertyValues.get(OfferRetargeting.IS_SUSPENDED)) BidBaseOpt.SUSPENDED.typedValue else null,
            if (propertyValues.get(OfferRetargeting.IS_DELETED)) BidBaseOpt.DELETED.typedValue else null
        ).filterNotNull().joinToString(",")

    fun priceToDbFormat(price: BigDecimal?): BigDecimal =
        price ?: BigDecimal.ZERO

    fun priceFromDbFormat(price: BigDecimal?): BigDecimal? =
        if (isNullOrZero(price)) null else price

    fun offerRetargetingsToCoreModelChanges(offerRetargetings: Collection<OfferRetargeting>): List<ModelChanges<OfferRetargeting>> =
        offerRetargetings.map(::offerRetargetingToCoreModelChanges)

    fun offerRetargetingToCoreModelChanges(offerRetargeting: OfferRetargeting): ModelChanges<OfferRetargeting> {
        val modelChanges = ModelChanges(offerRetargeting.id, OfferRetargeting::class.java)
        modelChanges.process(offerRetargeting.price, OfferRetargeting.PRICE)
        modelChanges.process(offerRetargeting.priceContext, OfferRetargeting.PRICE_CONTEXT)
        modelChanges.process(offerRetargeting.isSuspended, OfferRetargeting.IS_SUSPENDED)
        modelChanges.process(offerRetargeting.isDeleted ?: false, OfferRetargeting.IS_DELETED)
        return modelChanges
    }

    fun createOfferRetargetingModification(
        offerRetargetingsToAdd: List<OfferRetargeting> = emptyList(),
        offerRetargetingsToUpdate: List<ModelChanges<OfferRetargeting>> = emptyList(),
        offerRetargetingIdsToDelete: List<Long> = emptyList()
    ): OfferRetargetingModification = OfferRetargetingModification()
        .withOfferRetargetingAdd(offerRetargetingsToAdd)
        .withOfferRetargetingUpdate(offerRetargetingsToUpdate)
        .withOfferRetargetingIdsDelete(offerRetargetingIdsToDelete)
}
