package ru.yandex.direct.core.entity.offerretargeting.service

import ru.yandex.direct.core.entity.offerretargeting.container.OfferRetargetingModification
import ru.yandex.direct.core.entity.offerretargeting.container.OfferRetargetingModificationResult
import ru.yandex.direct.model.ModelProperty
import ru.yandex.direct.operation.Operation

internal interface OfferRetargetingOperation<M, T> : Operation<T> {
    /**
     * OfferRetargetingModification model property соответствующей операции
     */
    val modificationModelProperty : ModelProperty<OfferRetargetingModification, List<M>>

    /**
     * Список моделей офферных ретаргетингов, над которыми выполняется операция
     */
    val modifyingModels: List<M>

    /**
     * OfferRetargetingModificationResult model property соответствующей операции
     */
    val modificationResultModelProperty : ModelProperty<OfferRetargetingModificationResult, List<Long>>

    /**
     * Список id офферных ретаргетингов, которые были изменены в результате операции
     */
    val resultOfModification: List<Long>
}
