package ru.yandex.direct.core.entity.offerretargeting.validation

import ru.yandex.direct.validation.defect.params.NumberDefectParams
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.DefectId

object OfferRetargetingDefects {
    @JvmStatic
    fun offerRetargetingAlreadyDeleted(): Defect<Unit> =
        Defect(Gen.OFFER_RETARGETING_ALREADY_DELETED)

    @JvmStatic
    fun offerRetargetingCantBeUsedInAutoBudgetCampaign(): Defect<Unit> =
        Defect(Gen.OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN)

    @JvmStatic
    fun offerRetargetingAlreadySuspended(): Defect<Unit> =
        Defect(Gen.OFFER_RETARGETING_ALREADY_SUSPENDED)

    @JvmStatic
    fun offerRetargetingNotSuspended(): Defect<Unit> =
        Defect(Gen.OFFER_RETARGETING_NOT_SUSPENDED)

    @JvmStatic
    fun tooManyOfferRetargetingsInAdGroup(): Defect<NumberDefectParams> =
        Defect(
            Number.TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP,
            NumberDefectParams().withMax(MAX_OFFER_RETARGETINGS_IN_GROUP)
        )

    enum class Gen : DefectId<Unit> {
        OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN,
        OFFER_RETARGETING_ALREADY_DELETED,
        OFFER_RETARGETING_ALREADY_SUSPENDED,
        OFFER_RETARGETING_NOT_SUSPENDED,
    }

    enum class Number : DefectId<NumberDefectParams> {
        TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP
    }
}
