package ru.yandex.direct.core.entity.offlinereport.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OfflineReportJobParams {
    @JsonProperty
    private Long reportId;
    @JsonProperty
    private boolean isWithDailyInterval;
    @JsonProperty
    private String monthFrom;
    @JsonProperty
    private String monthTo;
    @JsonProperty
    private LocalDate dateFrom;
    @JsonProperty
    private LocalDate dateTo;
    @JsonProperty
    private OfflineReportType reportType;
    @JsonProperty
    private Long agencyId;

    @SuppressWarnings("unused") // используется при инстанциировании модели из json-представления
    public OfflineReportJobParams() {
    }

    public OfflineReportJobParams(Long reportId, OfflineReportType reportType, Long agencyId,
                                  String monthFrom, String monthTo) {
        this.reportId = reportId;
        this.reportType = reportType;
        this.agencyId = agencyId;
        this.isWithDailyInterval = false;
        this.monthFrom = monthFrom;
        this.monthTo = monthTo;
    }

    public OfflineReportJobParams(Long reportId, OfflineReportType reportType, Long agencyId,
                                  LocalDate dateFrom, LocalDate dateTo) {
        this.reportId = reportId;
        this.reportType = reportType;
        this.agencyId = agencyId;
        this.isWithDailyInterval = true;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
    }

    public Long getReportId() {
        return reportId;
    }

    public boolean getIsWithDailyInterval() {
        return isWithDailyInterval;
    }

    public String getMonthFrom() {
        return monthFrom;
    }

    public String getMonthTo() {
        return monthTo;
    }

    public LocalDate getDateFrom() {
        return dateFrom;
    }

    public LocalDate getDateTo() {
        return dateTo;
    }

    public OfflineReportType getReportType() {
        return reportType;
    }

    public Long getAgencyId() {
        return agencyId;
    }

    @Override
    public String toString() {
        return isWithDailyInterval
                ? "OfflineReportJobParams{" +
                "reportId=" + reportId +
                ", dateFrom='" + dateFrom + '\'' +
                ", dateTo='" + dateTo + '\'' +
                '}'
                : "OfflineReportJobParams{" +
                "reportId=" + reportId +
                ", monthFrom='" + monthFrom + '\'' +
                ", monthTo='" + monthTo + '\'' +
                '}';
    }
}
