package ru.yandex.direct.core.entity.offlinereport.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Описывает результат выполнения задачи на построение отчета
 */
public class OfflineReportJobResult {
    private final String reportUrl;
    private final String error;

    @JsonCreator
    public OfflineReportJobResult(@JsonProperty("reportUrl") String reportUrl,
                                  @JsonProperty("error") String error) {
        this.reportUrl = reportUrl;
        this.error = error;
    }

    public static OfflineReportJobResult error(String stacktrace) {
        return new OfflineReportJobResult(null, stacktrace);
    }

    public static OfflineReportJobResult success(String reportUrl) {
        return new OfflineReportJobResult(reportUrl, null);
    }

    @SuppressWarnings("unused")
    public String getReportUrl() {
        return reportUrl;
    }

    @SuppressWarnings("unused")
    public String getError() {
        return error;
    }
}
