package ru.yandex.direct.core.entity.organizations;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.TranslatableException;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectTranslations;
import ru.yandex.direct.organizations.swagger.OrganizationsClientException;

import static ru.yandex.direct.core.ErrorCodes.TYCOON_SERVICE_UNAVAILABLE;

/**
 * Исключение, бросаемое при получении {@link OrganizationsClientException} из клиента к Справочнику.
 */
@ParametersAreNonnullByDefault
public class OrganizationsClientTranslatableException extends TranslatableException {
    public OrganizationsClientTranslatableException() {
        super(TYCOON_SERVICE_UNAVAILABLE, OrganizationDefectTranslations.INSTANCE.organizationsServiceUnavailable());
    }
}
