package ru.yandex.direct.core.entity.organizations.repository;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.organization.model.BannerPermalink;
import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.core.entity.organization.model.OrganizationStatusPublish;
import ru.yandex.direct.core.entity.organization.model.PermalinkAssignType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.tables.BannerPermalinks.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.tables.Organizations.ORGANIZATIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

/**
 * Провайдер мапперов для {@link OrganizationRepository}.
 */
@ParametersAreNonnullByDefault
class OrganizationRepositoryMapperProvider {

    static JooqMapperWithSupplier<Organization> createOrganizationMapper() {
        return JooqMapperWithSupplierBuilder.builder(Organization::new)
                .map(convertibleProperty(Organization.CLIENT_ID, ORGANIZATIONS.CLIENT_ID,
                        ClientId::fromLong, ClientId::asLong))
                .map(property(Organization.PERMALINK_ID, ORGANIZATIONS.PERMALINK_ID))
                .map(property(Organization.CHAIN_ID, ORGANIZATIONS.CHAIN_ID))
                .map(convertibleProperty(Organization.STATUS_PUBLISH, ORGANIZATIONS.STATUS_PUBLISH,
                        OrganizationStatusPublish::fromSource, OrganizationStatusPublish::toSource))
                .build();
    }

    static JooqMapperWithSupplier<BannerPermalink> createBannerPermalinkMapper() {
        return JooqMapperWithSupplierBuilder.builder(BannerPermalink::new)
                .map(property(BannerPermalink.PERMALINK_ID, BANNER_PERMALINKS.PERMALINK))
                .map(convertibleProperty(BannerPermalink.PERMALINK_ASSIGN_TYPE,
                        BANNER_PERMALINKS.PERMALINK_ASSIGN_TYPE,
                        PermalinkAssignType::fromSource, PermalinkAssignType::toSource))
                .map(booleanProperty(BannerPermalink.IS_CHANGE_TO_MANUAL_REJECTED,
                        BANNER_PERMALINKS.IS_CHANGE_TO_MANUAL_REJECTED))
                .map(booleanProperty(BannerPermalink.PREFER_V_CARD_OVER_PERMALINK,
                        BANNER_PERMALINKS.PREFER_VCARD_OVER_PERMALINK))
                .build();
    }
}
