package ru.yandex.direct.core.entity.organizations.util;

import java.util.Optional;

import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndVcard;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithOrganization;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithOrganizationAndVcard;
import ru.yandex.direct.model.AppliedChanges;

public class PermalinkUtils {
    private PermalinkUtils() {
    }

    /**
     * Вычислить актуальное значение флага PreferVCardOverPermalink
     * @param bannerWithOrganization - текущее состояние банера
     * @return false - если флаг должен быть выключен или значение флага неактуально для типа баннера или его текущего состояния.
     */
    @Deprecated //use newCalculatePreferVCardOverPermalink
    public static <B extends OldBannerWithOrganization> boolean calculatePreferVCardOverPermalink(B bannerWithOrganization) {
        if (!(bannerWithOrganization instanceof OldBannerWithOrganizationAndVcard)) {
            return false;
        }
        OldBannerWithOrganizationAndVcard banner = (OldBannerWithOrganizationAndVcard) bannerWithOrganization;
        return banner.getVcardId() != null
                && banner.getPermalinkId() != null
                && banner.getPreferVCardOverPermalink() != null
                && banner.getPreferVCardOverPermalink();
    }

    /**
     * Вычислить актуальное значение флага PreferVCardOverPermalink
     * @param banner - текущее состояние банера
     * @return false - если флаг должен быть выключен или значение флага неактуально для типа баннера или его текущего состояния.
     */
    public static boolean newCalculatePreferVCardOverPermalink(BannerWithOrganizationAndVcard banner) {
        return banner.getVcardId() != null
                && banner.getPermalinkId() != null
                && banner.getPreferVCardOverPermalink() != null
                && banner.getPreferVCardOverPermalink();
    }

    /**
     * Вычислить актуальное изменение поля PreferVCardOverPermalink
     * @param appliedChanges - изменение баннера
     * @return null - если значение не нужно менять
     * @return true - если значение c false на true
     * @return false - если значение c true на false
     */
    public static <B extends OldBannerWithOrganization> Boolean getPreferVCardOverPermalinkUpdateValue(AppliedChanges<B> appliedChanges) {
        if (!(appliedChanges.getModel() instanceof OldBannerWithOrganizationAndVcard)) {
            return null;
        }
        AppliedChanges<OldBannerWithOrganizationAndVcard> appliedChange = appliedChanges.castModelUp(OldBannerWithOrganizationAndVcard.class);
        boolean oldValue = Optional.ofNullable(appliedChange.getOldValue(OldBannerWithOrganizationAndVcard.PREFER_V_CARD_OVER_PERMALINK)).orElse(false);
        boolean newValue = calculatePreferVCardOverPermalink(appliedChange.getModel());
        return newValue == oldValue ? null : newValue;
    }
}
