package ru.yandex.direct.core.entity.organizations.validation;

import java.util.Map;

import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.core.entity.organization.model.OrganizationStatusPublish;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.organizations.validation.OrganizationDefects.invalidOrganizationStatus;
import static ru.yandex.direct.core.entity.organizations.validation.OrganizationDefects.organizationNotFound;

public class OrganizationConstraints {

    public static Constraint<Long, Defect> checkStatus(Map<Long, Organization> organizations, boolean isCopy) {
        return permalinkId -> {
            if (permalinkId == null) {
                return null;
            }
            if (!organizations.containsKey(permalinkId)) {
                return organizationNotFound();
            }
            if (isCopy) {
                return null;
            }
            OrganizationStatusPublish status = organizations.get(permalinkId).getStatusPublish();
            if (status == OrganizationStatusPublish.PUBLISHED) {
                return null;
            }
            if (status == OrganizationStatusPublish.MOVED || status == OrganizationStatusPublish.TEMPORARILY_CLOSED) {
                return invalidOrganizationStatus(status);
            }
            return organizationNotFound();
        };
    }
}
