package ru.yandex.direct.core.entity.organizations.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

public interface OrganizationDefectTranslations extends TranslationBundle {

    OrganizationDefectTranslations INSTANCE = I18NBundle.implement(OrganizationDefectTranslations.class);

    @MessageFormatStub("Организация не найдена")
    Translatable organizationNotFound();

    @MessageFormatStub("Справочник временно недоступен")
    Translatable organizationsServiceUnavailable();

    @MessageFormatStub("Приоритет визитки над данными организации не будет включён, если не указана визитка или организация")
    Translatable invalidPreferVCardOverPermalink();

    @MessageFormatStub("Нет доступа к организации")
    Translatable hasNoAccessToOrganization();

    @MessageFormatStub("Невозможно одновременно подключить организацию и сеть")
    Translatable eitherPermalinkOrChainCanBeFilled();

    @MessageFormatStub("Неправильный статус организации: {0}")
    Translatable invalidOrganizationStatus(String status);
}
