package ru.yandex.direct.core.entity.organizations.validation;

import ru.yandex.direct.core.entity.organization.model.OrganizationStatusPublish;
import ru.yandex.direct.validation.result.Defect;

public class OrganizationDefects {

    public static Defect<Void> organizationNotFound() {
        return new Defect<>(OrganizationDefectIds.Gen.ORGANIZATION_NOT_FOUND);
    }

    public static Defect<Void> invalidPreferVCardOverPermalink() {
        return new Defect<>(OrganizationDefectIds.Gen.INVALID_PREFER_V_CARD_OVER_PERMALINK);
    }

    public static Defect<Void> hasNoAccessToOrganization() {
        return new Defect<>(OrganizationDefectIds.Gen.HAS_NO_ACCESS_TO_ORGANIZATION);
    }

    public static Defect<Void> eitherPermalinkOrChainCanBeFilled() {
        return new Defect<>(OrganizationDefectIds.Gen.EITHER_PERMALINK_OR_CHAIN_CAN_BE_FILLED);
    }

    public static Defect<String> invalidOrganizationStatus(OrganizationStatusPublish status) {
        return new Defect<>(OrganizationDefectIds.Statuses.INVALID_ORGANIZATION_STATUS, status.name());
    }
}
