package ru.yandex.direct.core.entity.payment.model;

import java.time.LocalDateTime;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TurnOnAutopayJobParams {

    @JsonProperty
    private String purchaseToken;

    @JsonProperty
    private AutopayParams autopayParams;

    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime actualTime;

    public String getPurchaseToken() {
        return purchaseToken;
    }

    public TurnOnAutopayJobParams withPurchaseToken(String purchaseToken) {
        this.purchaseToken = purchaseToken;
        return this;
    }

    public AutopayParams getAutopayParams() {
        return autopayParams;
    }

    public TurnOnAutopayJobParams withAutopayParams(AutopayParams autopayParams) {
        this.autopayParams = autopayParams;
        return this;
    }

    public LocalDateTime getActualTime() {
        return actualTime;
    }

    public TurnOnAutopayJobParams withActualTime(LocalDateTime actualTime) {
        this.actualTime = actualTime;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TurnOnAutopayJobParams params = (TurnOnAutopayJobParams) o;
        return Objects.equals(purchaseToken, params.purchaseToken) &&
                Objects.equals(autopayParams, params.autopayParams) &&
                Objects.equals(actualTime, params.actualTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(purchaseToken, autopayParams, actualTime);
    }
}
